RIC = window.RIC || {};
!function($){
	var MaskLoad = function(element, options) {
		this.$element = $(element);
		this.options = ($.type(options) == 'object') ? $.extend({}, MaskLoad.DEFAULTS, options) : MaskLoad.DEFAULTS;
		if (options == 'hide') {
			return this.remove();
		} 
	    this.build();
	}
	MaskLoad.DEFAULTS = {
			'min-height' : '300px'
	};
	MaskLoad.prototype.build = function(){
		if (this.$element.css("position") != 'relative') {
			this.options.position = 'relative';
		}
		var host = window.location.protocol + '//' + window.location.host;
		var m  = '<div class="J_maskLoading_" style="z-index:1020; background-color:#000;opacity:0.3;filter:alpha(opacity=30);top:0;left:0;width:100%;height: 100%; position:absolute;"></div>';
	        m += '<div class="J_maskLoading_" style="z-index:1021;left:48%;top:45%;position:absolute;">';
	        m += ' <div style="z-index:1022;padding:5px;position: absolute;">';
	        m += '	<i class="fa fa-spinner fa-spin" style="font-size:36px;color:#fff;"></i>'
	        m += ' </div>';
	        m += '</div>';
	    this.$element.css(this.options);
	    this.$element.find('.J_maskLoading_').remove();
	    this.$element.append(m);
	};
	MaskLoad.prototype.remove = function(){
		this.$element.find('.J_maskLoading_').remove();
	}
	function Plugin(options) {
		return this.each(function() {
	        return new MaskLoad(this, options);
	    })
	}
	$.fn.maskLoad = Plugin;
}(jQuery);
(function($){
	$.fn.getFormNV = function(){
		var valueMap = {}, $t = this;
		if($t.length == 0){
			return valueMap;
		}
		
		var keyExists = function(obj, key){
			return obj.hasOwnProperty(key)
		}
		$.each($t.serializeArray(), function(i, kv) {
			if (keyExists(valueMap, kv.name)) {
				valueMap[kv.name] = $.makeArray(valueMap[kv.name]);
				valueMap[kv.name].push(kv.value);
			} else {
				valueMap[kv.name] = kv.value;
			}
		});
		
		return valueMap;
	}
})(jQuery);
;(function($){
	$.layerLoad = function(){
		return layer.load(1, {
	        shade: [0.65, '#fff']
	    });
	}
	$.layerMsgLoad = function(content) {
		var content = content || '加载中...';
		return layer.msg(content, {
			time: 0,
			icon: 16,
			shade: [0.65, '#fff']
		});
	}
	$.layerMsg = function(tip, timeout) {
		timeout = timeout || 1500;
		return layer.msg(tip, {time: timeout});
	}
	$.layerClose = function(iid) {
		return iid ? layer.close(iid) : layer.closeAll();
	}
	$.isSuccess = function(ret) {
    	return _.has(ret, 'result') && (ret.result == 'success')
    }
    $.isFail = function(ret) {
    	return _.has(ret, 'result') && (ret.result == 'fail')
    }
    $.successResult = function(key, value) {
    	var ret = {'result': 'success'};
    	if (_.isObject(key)) {
    		$.extend(ret, key);
    	} else if(!_.isEmpty(key)) {
    		ret[key] = value;
    	}
    	
    	return ret;
    }
    $.failResult = function(reason) {
    	return {'result': 'fail', 'reason': reason};
    }
})(jQuery);
(function($, RIC){
	RIC.ServiceCall = function(opt, callback, fail, isNendLoadingTip, isSucessTip, isFailTip){
		var iid = null,  timeout = 50000;
		isNendLoadingTip = !(isNendLoadingTip === false), isSucessTip = (isSucessTip === true), isFailTip = (isFailTip === true);
		if (isNendLoadingTip) {
			iid = $.layerLoad();
		}
		var url = opt.url || '', host = 'http://pdd.szchengji-inc.com';
		if (url.toString().indexOf(location.protocol) == -1) {
			url = url.toString().replace('/(^\/*)/', '');
			url = host + url;
		}
		opt.url = url;
		
		var ajaxParam = {
			dataType: 'json',
			timeout: timeout,
			method: 'post'
		};
		$.extend(ajaxParam, opt);
		return $.ajax(ajaxParam).always(function(){
			iid && $.layerClose(iid);
		}).then(function(data){
			if (ajaxParam.jsonp && ajaxParam.jsonpCallBack) {
				($.type(callback) == 'function') && callback(data);
				return;
			}
			try {
				data = JSON.parse(data);
			} catch(e) { 
				
			}
			if (/success/.test(data['result'])) {
				if (isSucessTip) {
					$.layerMsg("数据调用成功");
				}
			} else {
				if (isFailTip) {
					$.layerMsg(data.reason || "加载数据失败", 0);
				}
			}
			($.type(callback) == 'function') && callback(data);
		}, function(event, XMLHttpRequest, ajaxOptions){
			($.type(fail) == 'function') && fail(ajaxOptions);
		});
	}
})(jQuery, window.RIC);
/* console shim*/
(function () {
    var f = function () {};
    if (!window.console) {
        window.console = {
            log:f, info:f, warn:f, debug:f, error:f
        };
    }
}());
Number.prototype.toNumber = function(n) {
    return n != undefined ? parseFloat(this.toFixed(n)) : this
};
String.prototype.toNumber = function(n) {
    if (this == "" || isNaN(this)) return 0;
    if (n != undefined) {
        var t = parseFloat(this).toFixed(n);
        return parseFloat(t)
    }
    return parseFloat(this)
};
Date.prototype.format = function(fmt) {   
	var o = {
		"M+" : this.getMonth()+1,				//月份   
		"D+" : this.getDate(),					//日   
		"H+" : this.getHours(),					//小时   
		"m+" : this.getMinutes(),				//分   
		"s+" : this.getSeconds(),				//秒   
		"q+" : Math.floor((this.getMonth()+3)/3),	//季度   
		"S"  : this.getMilliseconds()			//毫秒   
	};   
	if(/(Y+)/.test(fmt)) {
		fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
	}  
	for(var k in o) {
		if(new RegExp("("+ k +")").test(fmt)) {
			fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
		}
	} 
	return fmt;   
}