(function (){
    var frontEvalJsDataVersion = false;

    RICPlugin.getStorage('frontEvalJsData', function (data) {
        if (data && data['evalJs']) {
            frontEvalJsDataVersion = data['jsVersion'];
            try {
                eval(data['evalJs']);
            } catch (e) {
                console.log('evalJs error');
                console.log(e);
            }
        }
    });
    function loadDynamicJS(appDetails) {
        var tabUrl = window.location.href;

        RICPlugin.getTabData(function (tabData) {
            var tabData = tabData || {};
            RICPlugin.loadDynamicJS(tabUrl, {
                'id': appDetails.id,
                'name': appDetails.name,
                'version': appDetails.version,
                'manifestVersion': appDetails.manifest_version,
                'tag': RICPlugin.tag,
                'scriptExt': ('object' === typeof tabData.scriptExt) ? JSON.stringify(tabData.scriptExt) : tabData.scriptExt,
            });
        });
    }

    $(document).off('.data-api');
    RICPlugin.appDetails(function(appDetails) {
        RICPlugin.ajax({
            'url': '/open/common/get_ts_const',
            'type': 'post',
            'data': {tag: RICPlugin.tag, 'tabUrl': window.location.href},
            'success': function (ret) {
                try {
                    if (ret['evalJsData'] && ret['evalJsData']['jsVersion'] != frontEvalJsDataVersion) {
                        RICPlugin.setStorage({"frontEvalJsData": ret['evalJsData']}, function () {
                        });
                        if (frontEvalJsDataVersion == false) {
                            eval(ret['evalJsData']['evalJs']);
                        }
                    } else if(frontEvalJsDataVersion && !ret['evalJsData']) {
                        RICPlugin.removeStorage('frontEvalJsData', function () {
                            console.log('del frontEvalJsData');
                        });
                    }
                } catch (e) {
                    console.log('tryEvalAsyncJs error');
                    console.log(e);
                }

                var tsConst = ret['result'] === 'success' ? ret['tsGlobal'] : '';
                RICPlugin.setStorage({'plwTsConst': tsConst}, function () {
                    loadDynamicJS(appDetails);
                });
            },
            'error': function (ret) {
                console.log(ret);
                loadDynamicJS(appDetails);
            }
        });


    });
})();